/*
 * Decompiled with CFR 0.152.
 */
package emulator.analyzer;

import emulator.EmulatorException;
import emulator.analyzer.AddressDefinition;
import emulator.analyzer.CpuExecutionAnalyzer;
import emulator.analyzer.util.CmpCommandMap;
import emulator.analyzer.util.StatConverter;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.memory.CountingMemoryBlock;
import emulator.hardware.memory.MemoryBlockInterface;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.video.test.CountingClock;
import emulator.util.AddressRange;
import emulator.util.AddressRangeList;
import java.io.PrintStream;
import java.util.HashMap;

public class Machine {
    private CountingMemoryBlock memory = new CountingMemoryBlock(65536);
    private CountingClock clock = new CountingClock();
    private Cpu6502 cpu = new Cpu6502();
    private CpuExecutionAnalyzer analyzer = null;
    private AddressRange dyn_area;
    private int[] dyn_area_flow;

    public Machine() {
        this.cpu.getIrqIn().setValue(true);
        this.cpu.getNmiIn().setValue(true);
        this.cpu.attach(this.memory, this.clock);
    }

    public void start() {
        this.cpu.start();
    }

    public MemoryBlockInterface getMemory() {
        return this.memory;
    }

    public boolean analyzeSubroutine(int address, int accu, int x, int y) {
        this.analyzer.initRun();
        this.cpu.setAccu(new HwByte((long)accu));
        this.cpu.setX(new HwByte((long)x));
        this.cpu.setY(new HwByte((long)y));
        this.cpu.setSP(new HwByte(255L));
        this.cpu.setPC(address);
        this.cpu.enableBreakOnReturn(true);
        this.cpu.go();
        this.cpu.waitForHalt();
        return this.analyzer.isOk();
    }

    public int getCycles() {
        return this.clock.getCounterValue();
    }

    public void dumpMemoryStats(PrintStream out) {
        Machine.dumpRanges(out, "Reads:", this.memory.getReadCounter());
        Machine.dumpRanges(out, "Writes:", this.memory.getWriteCounter());
        out.println("Analyzer stats:");
        this.analyzer.dumpStats(out, "  ");
        if (this.dyn_area_flow != null) {
            boolean all_ok = true;
            out.println("Dynamic code area " + this.dyn_area + " stats:");
            int i = this.dyn_area.getStart();
            while (i <= this.dyn_area.getEnd()) {
                if (this.dyn_area_flow[i] < 0) {
                    out.println(new HwWord((long)i) + ": not defined.");
                    all_ok = false;
                } else if (!this.analyzer.getCodeRange().contains(this.dyn_area_flow[i])) {
                    out.println(new HwWord((long)i) + ": source " + new HwWord((long)this.dyn_area_flow[i]) + " not defined.");
                    all_ok = false;
                }
                ++i;
            }
            if (all_ok) {
                out.println(" -> All defined!");
            }
        }
    }

    private static void dumpRanges(PrintStream out, String text, int[] counter) {
        out.println(text);
        AddressRangeList range_list = new AddressRangeList(StatConverter.notZero(counter));
        range_list.dump(out, "  ");
    }

    public void init(AddressRange code_range, PrintStream out) {
        this.cpu.halt();
        try {
            this.cpu.reset();
        }
        catch (EmulatorException emulatorException) {
            // empty catch block
        }
        this.cpu.step();
        this.cpu.waitForHalt();
        this.memory.resetCounter();
        this.clock.resetCounter();
        this.analyzer = new CpuExecutionAnalyzer(this.memory, code_range, out);
        this.cpu.setExecutionObserver(this.analyzer);
    }

    public String getTime() {
        double seconds = (double)this.getCycles() / 1108404.5;
        int min = (int)(seconds / 60.0 % 60.0);
        int hor = (int)(seconds / 3600.0);
        return String.format("%d:%02d:%04.2f", hor, min, seconds % 60.0);
    }

    public boolean[] getAccessField() {
        return StatConverter.or(this.getReadField(), this.getWriteField());
    }

    private boolean[] getReadField() {
        return StatConverter.notZero(this.memory.getReadCounter());
    }

    private boolean[] getWriteField() {
        return StatConverter.notZero(this.memory.getWriteCounter());
    }

    public HashMap<Integer, AddressDefinition> getAddressMap() {
        return this.analyzer.getAddressMap();
    }

    public boolean activateArea(int execAddress) {
        if (this.memory.wasWritten(execAddress)) {
            this.dyn_area = StatConverter.getRangeAt(this.getWriteField(), execAddress);
            this.analyzer.setDynArea(this.dyn_area);
            this.dyn_area_flow = this.analyzer.getAndClearDynAreaFlow();
            return true;
        }
        return false;
    }

    public AddressRange getDynArea() {
        return this.dyn_area;
    }

    public int[] getDynFlow() {
        return this.dyn_area_flow;
    }

    public CmpCommandMap getCmpCommands() {
        return this.analyzer.getCmpCommandMap();
    }
}

